<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 19.12.13 10:59
 */

namespace VM\FinancialStatementsBundle\Services\DataStructure;


use VM\FinancialStatementsBundle\Services\FinansowanieInwestycjiPodsumowanie;
use VM\FinancialStatementsBundle\Services\FinansowanieProdukcji;
use VM\FinancialStatementsBundle\Services\LokatyPodsumowanie;

class SprawozdaniaDS extends AbstractDataStructure implements InterfaceDataStructure
{
    public $PodsumowanieFinansowaniaInwestycji;
    public $FinansowanieProdukcji;

    /**
     * @var int
     */
    public $rokPoczatkowy = 1;

    /**
     * @var int
     */
    public $ileIteracji = 1;

    /**
     * @var float
     */
    public $kapitalPodstawowy = array();

    public $przychodyFinansowe = array();

    public $lokatyWziete = array();
    public $lokatySplacone = array();

    public $kredytObrotowy = array();

    public $kredytObrotowySplata = array();

    public $odsetkiKredytuObrotowego = array();

    public function validate()
    {
        if(!($this->PodsumowanieFinansowaniaInwestycji instanceof FinansowanieInwestycjiPodsumowanie))
        {
            throw new \Exception('Niepoprawny FinansowanieInwestycjiPodsumowanie.');
        }

        if(!($this->FinansowanieProdukcji instanceof FinansowanieProdukcji))
        {
            throw new \Exception('Niepoprawny FinansowanieProdukcji.');
        }

        if(!is_numeric($this->rokPoczatkowy) || !is_int($this->rokPoczatkowy))
        {
            throw new \Exception('Rok początkowy powinien być liczbą całkowitą.');
        }

        if($this->rokPoczatkowy <= 0)
        {
            throw new \Exception('Rok początkowy powinien być większy od 0.');
        }

        if(!is_numeric($this->ileIteracji) || !is_int($this->ileIteracji))
        {
            throw new \Exception('Ilość iteracji powinna być liczbą całkowitą.');
        }

        if($this->ileIteracji <= 0)
        {
            throw new \Exception('Ilość iteracji powinna być większą od 0.');
        }

        if(!is_numeric($this->kapitalPodstawowy))
        {
            throw new \Exception('Kapital podstawowy powinien być liczbą rzeczywistą.');
        }

        if($this->kapitalPodstawowy <= 0)
        {
            throw new \Exception('Kapital podstawowy powinien być większy od 0.');
        }

        if(!is_array($this->przychodyFinansowe))
        {
            throw new \Exception('Przychody finansowe powinny być tablica.');
        }

        foreach($this->przychodyFinansowe as $przych)
        {
            if($przych < 0)
            {
                throw new \Exception('Wszystkie przychody finansowe powinny być większe lub równe 0.');
            }
        }

        if(!is_array($this->lokatyWziete))
        {
            throw new \Exception('Lokaty wziete powinny być tablicą.');
        }

        if(!is_array($this->lokatySplacone))
        {
            throw new \Exception('Lokaty splacone powinny być tablicą.');
        }

        if(!is_array($this->kredytObrotowy))
        {
            throw new \Exception('Kredyt obrotowy powinien być tablica.');
        }

        foreach($this->kredytObrotowy as $kredyt)
        {
            if($kredyt['value'] < 0)
            {
                throw new \Exception('Wszystkie kredyty obrotowe powinny być większe lub równe 0.');
            }
        }

        if(!is_array($this->kredytObrotowySplata))
        {
            throw new \Exception('Spłata kredytu obrotowego powinna być tablica.');
        }

        foreach($this->kredytObrotowySplata as $kredyt)
        {
            if($kredyt['value'] < 0)
            {
                throw new \Exception('Wszystkie spłaty kredytów obrotowych powinny być większe lub równe 0.');
            }
        }

        if(!is_array($this->odsetkiKredytuObrotowego))
        {
            throw new \Exception('Odsetki kredytu obrotowego powinny być tablica.');
        }

        foreach($this->odsetkiKredytuObrotowego as $odsetki)
        {
            if($odsetki < 0)
            {
                throw new \Exception('Wszystkie odsetki kredytów obrotowych powinny być większe lub równe 0.');
            }
        }

        return true;
    }
} 